Imports System.Data
Imports System.Data.SqlClient

Module Module1
    Public Sub PrintTable(ByVal ds As DataSet)
        ' Afficher les rsultats de la table.
        Console.WriteLine("Voici ce que nous avons actuellement:")
        Dim invTable As DataTable = ds.Tables("Inventory")

        ' Afficher le nom des colonnes.
        Dim curCol As Integer
        For curCol = 0 To invTable.Columns.Count - 1
            Console.Write(invTable.Columns(curCol).ColumnName.Trim() & vbTab)
        Next
        Console.WriteLine()

        ' Afficher chaque cellule.
        Dim curRow As Integer
        For curRow = 0 To invTable.Rows.Count - 1
            For curCol = 0 To invTable.Columns.Count - 1
                Console.Write(invTable.Rows(curRow)(curCol).ToString().Trim() & vbTab)
            Next
            Console.WriteLine()
        Next
        Console.WriteLine()
    End Sub

    Sub Main()
        ' Etape 1: Crer une connexion et un adaptateur
        Dim cn As SqlConnection = New SqlConnection("server=(local);uid=sa;pwd=;database=Cars;Integrated Security=SSPI")
        Dim dAdapt As SqlDataAdapter = New SqlDataAdapter("Select * from Inventory", cn)

        ' Etape 2: Dtruire l'enregistrement que nous avons insr.
        cn.Open()
        Dim killCmd As SqlCommand = New SqlCommand("DELETE FROM Inventory WHERE CarID = '666'", cn)
        killCmd.ExecuteNonQuery()
        cn.Close()

        ' Etape 3: Construire la commande d'insertion.
        dAdapt.InsertCommand = New SqlCommand("INSERT INTO Inventory (CarID, Make, Color, PetName) VALUES (@CarID, @Make, @Color, @PetName)", cn)

        ' Etape 4: Crer les paramtres pour chaque colonne dans la table Inventory.
        Dim workParam As SqlParameter
        workParam = dAdapt.InsertCommand.Parameters.Add(New SqlParameter("@CarID", SqlDbType.Int))
        workParam.SourceColumn = "CarID"
        workParam.SourceVersion = DataRowVersion.Current

        workParam = dAdapt.InsertCommand.Parameters.Add(New SqlParameter("@Make", SqlDbType.VarChar))
        workParam.SourceColumn = "Make"
        workParam.SourceVersion = DataRowVersion.Current

        workParam = dAdapt.InsertCommand.Parameters.Add(New SqlParameter("@Color", SqlDbType.VarChar))
        workParam.SourceColumn = "Color"
        workParam.SourceVersion = DataRowVersion.Current

        workParam = dAdapt.InsertCommand.Parameters.Add(New SqlParameter("@PetName", SqlDbType.VarChar))
        workParam.SourceColumn = "PetName"
        workParam.SourceVersion = DataRowVersion.Current

        ' Etape 5: Remplir la table de donnes.
        Dim myDS As DataSet = New DataSet()
        dAdapt.Fill(myDS, "Inventory")
        PrintTable(myDS)

        ' Etape 6: Ajouter la nouvelle ligne.
        Dim newRow As DataRow = myDS.Tables("Inventory").NewRow()
        newRow("CarID") = 666
        newRow("Make") = "SlugBug"
        newRow("Color") = "Rose"
        newRow("PetName") = "Cranky"
        myDS.Tables("Inventory").Rows.Add(newRow)

        ' Etape 7: Retour  la base de donne et affichage.
        Try
            dAdapt.Update(myDS, "Inventory")
            myDS.Dispose()
            myDS = New DataSet()
            dAdapt.Fill(myDS, "Inventory")
            PrintTable(myDS)
        Catch e As Exception
            Console.Write(e.ToString())
        End Try
    End Sub
End Module
